#! /usr/bin/python
#
# Utility command to add a remote to all repositories
#
#  Utilize something like this, ahead of time, to cache https credentials...
#  git config --global credential.helper cache
#  git config --global credential.https://DNS               

import subprocess


projects = ['ISAAC-developer-docs',
			'ISAAC',
			'ISAAC-term-convert-cpt',
			'ISAAC-term-convert-cvx',
			'ISAAC-term-convert-nucc',
			'ISAAC-term-convert-hl7v3',
			'ISAAC-term-convert-rf2',
			'ISAAC-term-convert-vhat',
			'ISAAC-term-convert-loinc',
			'ISAAC-term-convert-rxnorm',
			'ISAAC-db-builder-solor',
			'ISAAC-db-builder-vhat',
			'ISAAC-db-builder-vets',
			'ISAAC-fx-gui',
			'ISAAC-fx-gui-pa',
			'ISAAC-rest',
			'ISAAC-file-transfer-utils',
			'rails_common',
			'rails_komet',
			'rails_prisme',
			'apache_extensions',
			'aitc_install']

def git(*args):
	return subprocess.check_call(['git'] + list(args))

remoteName = 'origin'
remoteBaseURL = 'https://DNS              :PORT'

for project in projects:
	print("==================================")
	print("Updating Remote of " + project + " current:")
	git("-C", project, "remote", "-v")
	git("-C", project, "remote", "set-url", remoteName, remoteBaseURL + project + ".git")
	print("New:")
	git("-C", project, "remote", "-v")
	print("==================================")
	print("");